#include <cstdio>
#include <SFML/Graphics.hpp>
#include <string>

int main(int argc, char ** argv){
	if(argc < 3){
		std::puts("Expecting launch parameters [input filepath] [output filename]");
		return 1;
	}

	const std::string inputFile(argv[1]);
	const std::string outputFile(argv[2]);

	sf::RenderWindow window(sf::VideoMode(800, 600), "test");
	window.setVerticalSyncEnabled(true);

	sf::Image image;
	if(!image.loadFromFile(inputFile)){
		std::printf("Error opening %s\n", inputFile.c_str());
		return 1;
	}
	if(!image.saveToFile(outputFile)){
		std::printf("Error saving %s\n", outputFile.c_str());
		return 1;
	}

	sf::Texture texture;
	texture.loadFromImage(image);
	sf::Sprite sprite(texture);
	sprite.setPosition(0.f, 0.f);

	while(window.isOpen()){
		sf::Event e;
		while(window.pollEvent(e)){
			if(e.type == sf::Event::Closed){
				window.close();
				return 0;
			}
		}

		window.clear(sf::Color::Black);
		window.draw(sprite);
		window.display();
	}

	return 0;
}
