#include <QtWidgets>
#include "Window.h"

class DoubleEdit : public QLineEdit
{
public:
  DoubleEdit(double min,double max,int precision,QWidget* parent=NULL) : QLineEdit(parent)
  {
    setValidator(new QDoubleValidator(min,max,precision,this));
  }

  double value(void) { return(text().toDouble()); }
  void setValue(double value)
  {
    setText(QString("%1").arg(value,0,'f',static_cast<const QDoubleValidator*>(validator())->decimals(),'0'));
  }

protected:
  void focusOutEvent(QFocusEvent* event)
  {
    setValue(value());
    QLineEdit::focusOutEvent(event);

    qDebug() << "focusOutEvent";
    return;
  }
};

Window::Window()
{
  qDebug() << "Window::Window";

  QLineEdit* lineEdit = new QLineEdit;
  lineEdit->setPlaceholderText("Placeholder Text");
  lineEdit->setFocus();

  DoubleEdit* doubleEdit = new DoubleEdit(0.0,100.0,2);
  doubleEdit->setValue(12.134);

  QHBoxLayout* layout = new QHBoxLayout;
  layout->addWidget(lineEdit);
  layout->addWidget(doubleEdit);

  setLayout(layout);
  setWindowTitle(tr("Double Edit Test"));
}
