void DataView::renderStream()
{
  if (!part || !stream) return;
  int p, s;

  glLineWidth(2.0);

  glEnable(GL_LIGHTING);
  for (p = 0; p < npart; p++) {
    vec3d prvpos = stream[p].pos;
    s = 1;
    while (s < nsteps && (s < part[p].died || !part[p].died)) {
      double c1 = (nsteps - s) / (float)nsteps;
      double c2 = s / (float)nsteps;
      vec3d curpos = stream[s * npart + p].pos;
      vec3d normal = stream[s * npart + p].normal;
      vec3d dir = stream[s * npart + p].dir;

      // Calculate vertices of arrowhead
      vec3d op = outerProduct(normal, curpos - prvpos);
      vec3d p1 = curpos - (curpos - prvpos) / 4 + op;
      vec3d p2 = curpos - (curpos - prvpos) / 4 - op;
      glNormal3f(normal.x, normal.y, normal.z);
      
      // Render line
      glBegin(GL_LINES);
      glColor4f(c1, c2, 1.0, 0.0);
      glVertex3f(prvpos.x, prvpos.y, prvpos.z);
      glColor4f(c1, c2, 1.0, 1.0);
      glVertex3f(curpos.x, curpos.y, curpos.z);
      glEnd();

      // Render arrow head
      glBegin(GL_TRIANGLES);
      glVertex3f(p1.x, p1.y, p1.z);
      glVertex3f(p2.x, p2.y, p2.z);
      glVertex3f(curpos.x, curpos.y, curpos.z);
      glEnd();
      
      prvpos = curpos;
      s++;
    }
  }
  glDisable(GL_LIGHTING);
}
